(function(exports) {
	var response_lenght = 10;
	var queryTimeout = 1000;

	var access_commands = [
			{"name": l100n.localize_string("access_control_on"), "command": "0x10000"},
			{"name": l100n.localize_string("access_control_off"), "command": "0x20000"},
			{"name": l100n.localize_string("access_level_reset"), "command": "0x30000"},
			{"name": l100n.localize_string("change_password"), "command": "0x40000"},
			//{"name": l100n.localize_string("counter_reset"), "command": "1991"},
			{"name": l100n.localize_string("download_settings"), "command": "0x00050000"},
			{"name": l100n.localize_string("upload_settings"), "command": "0x00060000"},
			{"name": l100n.localize_string("reboot"), "command": "0x746f6f62"}
	];

	var board_types = [
			{"name": "А - 230 V AC", "command": "1"},
			{"name": "D - 24 V DC", "command": "2"}
	];

	var module_types = [
			{"name": l100n.localize_string("dummy"), "command": "0"},
			{"name": "MCU - 1 - 10HDI", "command": "1"},
			{"name": "MCU - 2 - 10DI", "command": "2"},
			{"name": "MCU - 3 - 8AI", "command": "3"},
			{"name": "MCU - 4 - 8CTI", "command": "4"},
			{"name": "MCU - 5 - 4RTD", "command": "5"},
			{"name": "MCU - 5 - 4TI", "command": "19"},
			{"name": "MCU - 7 - 2AO", "command": "7"},
			{"name": "MCU - 8 - 4RO", "command": "8"},
			{"name": "MCU - 9 - 10HDO", "command": "9"},
			{"name": "MCU - 13 - F LCD", "command": "13"},
			{"name": "MCU - 14 - F IO", "command": "14"},
			{"name": "H - EM", "command": "16"},
			{"name": "L - EM", "command": "17"},
			{"name": l100n.localize_string("slot_absent"), "command": "255"}
	];

	var connection_scheme = [
			{"name": "4LN3", "command": "0"},
			{"name": "4LL3/3LL3", "command": "8"},
			{"name": "4LN2", "command": "1"},
			{"name": "3LN3", "command": "4"},
			{"name": "3LN2", "command": "5"},
			{"name": "3LL2", "command": "9"},
			{"name": "3OP3", "command": "2"},
			{"name": "3OP2", "command": "3"}
	];

	var current_range = [
		{"name": l100n.localize_string("H-5A/L-0,1A"), "command": "1"},
		{"name": l100n.localize_string("H-1,25A/L-0,025A"), "command": "4"}
];

	var current_diff_range = [
		{"name": l100n.localize_string("500µA"), "command": "1"},
		{"name": l100n.localize_string("125µA"), "command": "4"}
];

	var access_values = [
			{"new_value": l100n.localize_string("off"), "raw_value": "0"},
			{"new_value": l100n.localize_string("user"), "raw_value": "1"},
			{"new_value": l100n.localize_string("admin"), "raw_value": "2"}
	];

	var default_checkbox_values = [
			{"new_value": l100n.localize_string("off"), "raw_value": "0"},
			{"new_value": l100n.localize_string("on"), "raw_value": "1"}
	];

	var on_off_values = [
			{"name": l100n.localize_string("off"), "command": "0"},
			{"name": l100n.localize_string("on"), "command": "1"}
	];

	var yes_no_values = [
		{"name": l100n.localize_string("no"), "command": "0"},
		{"name": l100n.localize_string("yes"), "command": "1"}
	];

	var baudrate = [
		{"name": l100n.localize_string("9.6"), "command": "9600"},
		{"name": l100n.localize_string("19.2"), "command": "19200"},
		{"name": l100n.localize_string("38.4"), "command": "38400"},
		{"name": l100n.localize_string("57.6"), "command": "57600"},
		{"name": l100n.localize_string("115.2"), "command": "115200"}
	];

	var CAN_speed = [
		{"name": "50", "command": "50000"},
		{"name": "100", "command": "100000"},
		{"name": "125", "command": "125000"},
		{"name": "250", "command": "250000"},
		{"name": "500", "command": "500000"},
		{"name": "800", "command": "800000"},
		{"name": "1000", "command": "1000000"}
	];

	exports.sensor_type_rtd = [
		{"name": "М - 50", "command": "1"},
		{"name": "Pt - 50", "command": "2"},
		{"name": "Pt - 100", "command": "3"},
		{"name": "П - 50", "command": "4"},
		{"name": "П - 100", "command": "5"}
	];

	exports.sensor_type_ai = [
		{"name": "0 - 20", "command": "0"},
		{"name": "4 - 20", "command": "200"},
	];

	var parity = [
		{"name": l100n.localize_string("off"), "command": "0"},
		{"name": l100n.localize_string("even"), "command": "1"},
		{"name": l100n.localize_string("odd"), "command": "2"}
	];

	var stopbits = [
		{"name": "1", "command": "1"},
		{"name": "2", "command": "2"}
	];

	var user_app_status = [
		{"new_value": l100n.localize_string("ua_absent"), "raw_value": "0"},
		{"new_value": l100n.localize_string("ua_start"), "raw_value": "1"},
		{"new_value": l100n.localize_string("ua_stop"), "raw_value": "2"}
	];

	var data_type_template = {"templates": [
			{"index": "1027_1","template": "combobox", "commands": board_types},
			{"index": "1027_2","template": "combobox", "commands": module_types},
			{"index": "1027_3","template": "combobox", "commands": module_types},
			{"index": "1027_4","template": "combobox", "commands": module_types},
			{"index": "1027_5","template": "combobox", "commands": module_types},
			{"index": "1027_6","template": "combobox", "commands": module_types},
			{"index": "1027_7","template": "combobox", "commands": module_types},
			{"index": "1027_8","template": "combobox", "commands": module_types},
			{"index": "1027_9","template": "combobox", "commands": module_types},
			{"index": "2081_1","template": "datetime"},
			{"index": "2002_1","template": "combobox", "commands": access_commands},
			{"index": "2001_9","template": "change_value", "commands": access_values},
			{"index": "2002_2","template": "password"},
			{"index": "1018_3","template": "ip_addr"},
			{"index": "2000_3","template": "ip_addr"},
			{"index": "2000_6","template": "ip_addr"},
			{"index": "2213_2","template": "ip_addr"},
			{"index": "2213_3","template": "ip_addr"},
			{"index": "2213_4","template": "ip_addr"},
			{"index": "2213_5","template": "ip_addr"},
			{"index": "2213_6","template": "ip_addr"},
			{"index": "2001_5","template": "battery"},
			{"index": "2143_4","template": "combobox", "commands": parity},
			{"index": "2143_5","template": "combobox", "commands": stopbits},
			{"index": "2213_1","template": "combobox", "commands": on_off_values},
			{"index": "2143_1","template": "combobox", "commands": yes_no_values},
			{"index": "2143_2","template": "combobox", "commands": baudrate},
			{"index": "2103_1","template": "combobox", "commands": yes_no_values},
			{"index": "2103_2","template": "combobox", "commands": CAN_speed},
			{"index": "1011_1","template": "restore_params"},
			{"index": "5001_1","template": "change_value", "commands": user_app_status},
			{"index": "5000_2","template": "datetime_simple"},
			{"index": "5000_3","template": "ip_addr"},
	]};

	for (var board_number = 1; board_number < 9; board_number++)
    {
		//{"index": "4060_1","template": "combobox", "commands": connection_scheme},
		var eds_index2 = 0x4060 + (board_number-1)*0x100
		data_type_template.templates.push({"index": `${eds_index2.toString(16).toUpperCase()}_1`,"template": "combobox", "commands": connection_scheme})

		//{"index": "4060_2","template": "combobox", "commands": current_range},
		var eds_index3 = 0x4060 + (board_number-1)*0x100
		data_type_template.templates.push({"index": `${eds_index3.toString(16).toUpperCase()}_2`,"template": "combobox", "commands": current_range})

		//{"index": "4060_3","template": "combobox", "commands": current_diff_range},
		var eds_index4 = 0x4060 + (board_number-1)*0x100
		data_type_template.templates.push({"index": `${eds_index4.toString(16).toUpperCase()}_3`,"template": "combobox", "commands": current_diff_range})

		for (var eds_subindex = 1; eds_subindex < 9; eds_subindex++)
		{
			var eds_index1 = 0x3F44 + board_number*0x100
			var template1 = {"index": `${eds_index1.toString(16).toUpperCase()}_${eds_subindex}`,"template": "combobox", "commands": on_off_values}
			data_type_template.templates.push(template1)
		}
	}

	exports.add_template = function(template)
	{
		data_type_template.templates.push(template)
	}
	exports.module_types = function() { return module_types;}
	exports.response_lenght = function() { return response_lenght;}
	exports.queryTimeout = function() { return queryTimeout;}
	exports.data_type_template = function() { return data_type_template;}
	exports.default_checkbox_values = function() { return default_checkbox_values;}
})(this.configuration = {});
